% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_ml.R
\name{hanr_ml}
\alias{hanr_ml}
\title{Anomaly detector based on machine learning regression.}
\usage{
hanr_ml(model, sw_size = 15)
}
\arguments{
\item{model}{DALToolbox regression model}

\item{sw_size}{sliding window size}
}
\value{
\code{hanr_ml} object
}
\description{
Anomaly detection using daltoolbox regression
The regression model adjusts to the time series. Observations distant from the model are labeled as anomalies.
A set of preconfigured regression methods are described in \url{https://cefet-rj-dal.github.io/daltoolbox/}.
They include: ts_elm, ts_conv1d, ts_lstm, ts_mlp, ts_rf, ts_svm
}
\examples{
library(daltoolbox)

#loading the example database
data(har_examples)

#Using example 1
dataset <- har_examples$example1
head(dataset)

# setting up time series regression model
model <- hanr_ml(ts_elm(ts_norm_gminmax(), input_size=4, nhid=3, actfun="purelin"))

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection |> dplyr::filter(event==TRUE))

}
