% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_layers_metadata.R
\name{get_layers_metadata}
\alias{get_layers_metadata}
\alias{get_layers_metadata.character}
\alias{get_layers_metadata.wfs}
\alias{get_layers_metadata.wms}
\title{Metadata for one couple of apikey and data_type}
\usage{
get_layers_metadata(apikey, data_type)

\method{get_layers_metadata}{character}(apikey, data_type)

\method{get_layers_metadata}{wfs}(apikey, data_type)

\method{get_layers_metadata}{wms}(apikey, data_type)
}
\arguments{
\item{apikey}{API key from \code{get_apikeys()} or directly
from the \href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{data_type}{Should be \code{"wfs"} or \code{"wms"}. See details for more
information about these two Webservice formats.}
}
\value{
data.frame with name of layer, abstract and crs
}
\description{
Metadata are retrieved using the IGN APIs. The execution time can
be long depending on the size of the metadata associated with
the API key and the overload of the IGN servers.
}
\details{
\itemize{
\item WFS is a standard protocol defined by the OGC (Open Geospatial Consortium)
and recognized by an ISO standard. The reference document is available
on the \href{https://www.ogc.org/standards/wfs}{OGC website}. The Geoportail
WFS service implements version 2.0 of this protocol. The WFS service
of the Geoportal gives access to objects from different IGN databases:
BD TOPO®, BD CARTO®, BD ADRESSE®, BD FORET® or PARCELLAIRE EXPRESS (PCI).
\item WMS is a standard protocol defined by the OGC
(Open Geospatial Consortium) and recognized by an ISO standard.
The reference document is available on the
\href{https://www.ogc.org/standards/wms}{OGC website}.
\item For further more detail, check \href{https://geoservices.ign.fr/documentation/services/api-et-services-ogc}{IGN documentation page}
}
}
\examples{
\dontrun{

apikey <- get_apikeys()[4]
metadata_table <- get_layers_metadata(apikey, "wms")
all_layer_name <- metadata_table$name
abstract_of_MNT <- metadata_table[1,3]
crs_of_MNT <- unlist(metadata_table[1,4])

# list with every wfs metadata
list_metadata = lapply(X = get_apikeys(),
                       FUN = get_layers_metadata,
                       data_type = "wfs")

# Convert list to one single data.frame
all_metadata = dplyr::bind_rows(list_metadata)
}

}
\seealso{
\code{\link[=get_apikeys]{get_apikeys()}}
}
