% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-hbr.R
\docType{methods}
\name{plot_hbr_freq,hbr-method}
\alias{plot_hbr-freq.hbr}
\alias{plot_hbr_freq}
\alias{plot_hbr_freq,hbr-method}
\title{Plots frequencies of a reconstructed haplotype-block along the chromosome}
\usage{
\S4method{plot_hbr_freq}{hbr}(object, hbr_id = 1, replicate, timepoint,
  window = 1, cols = NULL, add = F, sumstat = "mean", cex = 0.7,
  xlab = "Genomic position [Mb]", ylab = "Marker frequency", xlim = NULL,
  ylim = c(0, 1), pch = 20, lwd = 2)
}
\arguments{
\item{object}{object of class \code{\link{hbr}} containing the results of reconstructed 
haplotype-blocks}

\item{hbr_id}{id (integer) of the haplotype-block to be plotted}

\item{replicate}{numeric vector of integers specifying the replicates for which results
should be plotted}

\item{timepoint}{numeric vector of time points for which the results shouls be plotted}

\item{window}{window size over which frequencies are averaged (results are plotted for windows
overlapping by windows/2)}

\item{cols}{vector of colors with the length of the specified libraries}

\item{add}{logical specifying if a new plot should be created or haplotype-block frequencies 
are added to an existing plot.}

\item{sumstat}{Summary statistics used for the y-values in a window. Either 
specify "mean" (the default) or "median".}

\item{cex}{scaling of the point size in the output plot}

\item{xlab}{x-label in the output plot}

\item{ylab}{y-label in the output plot}

\item{xlim}{vector of the limits on the x-axis in the output plot}

\item{ylim}{vector of the limits on the y-axis in the output plot}

\item{pch}{option to specify symbols to use when plotting points in the output plot}

\item{lwd}{line width in the output plot}
}
\description{
Plots frequencies of a reconstructed haplotype-block along the chromosome
}
\details{
The plotting method operates on \code{\link{hbr}} objects and returns a plot containing
frequencies of a respective haplotype-block along the chromosome for specified time points and 
replicates.
}
\author{
Susanne U. Franssen
}
\seealso{
\code{\link{hbr}} \code{\link{ex_dat}} \code{\link{summary.hbr}} \code{\link{plot.hbr}} 
\code{\link{plot_cluster_trajectories}} \code{\link{plot_marker_trajectories}}
\code{\link{map}} \code{\link{rev_map}} \code{\link{markers}} 
\code{\link{inspect_window}} \code{\link{inspect_window_PCA}} \code{\link{inspect_window_avLink}}
\code{\link{inspect_window_dbScan}} \code{\link{number_hbr}}
}

