% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epetition.R
\name{epetition}
\alias{epetition}
\alias{hansard_epetition}
\title{Individual epetitions}
\usage{
epetition(ID = NULL, by_constituency = FALSE, extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case", verbose = TRUE)

hansard_epetition(ID = NULL, by_constituency = FALSE,
  extra_args = NULL, tidy = TRUE, tidy_style = "snake_case",
  verbose = TRUE)
}
\arguments{
\item{ID}{The ID of a given petition. If \code{NULL}, returns all
epetitions. Defaults to \code{NULL}. See \code{\link[=epetition_tibble]{epetition_tibble()}}
for a greater degree of flexibility when querying all epetitions.}

\item{by_constituency}{Accepts either \code{TRUE} or \code{FALSE}.
If \code{TRUE}, provides a tibble with a breakdown of signatures for
each petition, by constituency. Defaults to \code{FALSE}.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts one of \code{'snake_case'}, \code{'camelCase'}
and \code{'period.case'}. Defaults to \code{'snake_case'}.}

\item{verbose}{If \code{TRUE}, displayes messages on the console on the
progress of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with details on electronic petitions
submitted to parliament.
}
\description{
Imports data on a given epetition. For bulk epetion data,
see \code{\link[=epetition_tibble]{epetition_tibble()}}.
}
\examples{
\dontrun{
x <- epetition(ID = 706964, by_constituency = TRUE)
}

}
\seealso{
\code{\link[=epetition_tibble]{epetition_tibble()}}
}
