% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lords_interests.R
\name{lords_interests}
\alias{lords_interests}
\alias{hansard_lords_interests}
\title{Peers' registered interests}
\usage{
lords_interests(peer_id = NULL, extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case", verbose = FALSE)

hansard_lords_interests(peer_id = NULL, extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case", verbose = FALSE)
}
\arguments{
\item{peer_id}{The ID of a member of the House of lords. If \code{NULL}, returns a tibble with all listed financial interests for all members. Defaults to \code{NULL}.}

\item{extra_args}{Additional parameters to pass to API. See the \href{http://explore.data.parliament.uk/}{API documentation} or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if \code{tidy = TRUE}. Accepts one of \code{'snake_case'}, \code{'camelCase'} and \code{'period.case'}. Defaults to \code{'snake_case'}.}

\item{verbose}{If \code{TRUE}, returns data to console on the progress of the API request. Defaults to \code{FALSE}.}
}
\value{
A tibble with details on the interests of peers in the House of Lords.
}
\description{
Registered financial interests of members of the House of Lords. If \code{peer_id=NULL} the actual details of registered interests are stored in a nested data frame.
}
\examples{
\dontrun{
x <- lords_interests(4170)

y <- lords_interests()
}
}
