% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/papers_laid.R
\name{papers_laid}
\alias{papers_laid}
\title{Imports data on papers laid before the House.}
\usage{
papers_laid(withdrawn = FALSE, house = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")
}
\arguments{
\item{withdrawn}{If TRUE, only returns withdrawn papers. Defaults to FALSE.}

\item{house}{The house the paper was laid in. Accepts 'commons' and 'lords'. If NULL, returns both House of Commons and House of Lords. This parameter is case-insensitive. Defaults to NULL.}

\item{start_date}{The earliest date to include in the tibble. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with details on papers laid before the given House.
}
\description{
Imports data on papers laid before the House.
}
\examples{
\dontrun{
x <- papers_laid(withdrawn = FALSE, house = 'commons')

x <- papers_laid(withdrawn = TRUE, house = NULL)
}

}
\keyword{Laid}
\keyword{Papers}
