% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_diversities.R
\name{diversities_table}
\alias{diversities_table}
\title{Prints Table of Diversities}
\usage{
diversities_table(x, ...)
}
\arguments{
\item{x}{a hagis.diversities object generated by \code{\link[=calculate_diversities]{calculate_diversities()}}}

\item{...}{other arguments passed to \code{\link[pander:panderOptions]{pander::panderOptions()}}}
}
\value{
A \link[=pandoc.table]{pander} object of diversities
}
\description{
Print the frequency table of diversities from a \code{hagis.diversities} object
The resulting object is a \link{pander} table (a text object for Markdown) for
ease of use in reporting and viewing in the console.
}
\examples{
# locate system file for import
Ps <- system.file("extdata", "practice_data_set.csv", package = "hagis")

# import 'practice_data_set.csv'
Ps <- read.csv(Ps)
head(Ps)

# calculate susceptibilities with a 60 \% cutoff value
diversities <- calculate_diversities(x = Ps,
                                     cutoff = 60,
                                     control = "susceptible",
                                     sample = "Isolate",
                                     gene = "Rps",
                                     perc_susc = "perc.susc")

# print the diversities table
diversities_table(diversities)

}
\seealso{
\code{\link[=calculate_diversities]{calculate_diversities()}}, \code{\link[=individual_pathotypes]{individual_pathotypes()}}
}
