% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hablar.R
\name{find_in_df}
\alias{find_in_df}
\alias{find_duplicates}
\alias{find_na}
\alias{find_irrational}
\alias{find_nan}
\alias{find_inf}
\title{Special filters}
\usage{
find_duplicates(.data, ...)

find_na(.data, ...)

find_irrational(.data, ...)

find_nan(.data, ...)

find_inf(.data, ...)
}
\arguments{
\item{.data}{a data frame}

\item{...}{variables that should be considered. If empty, all variables are used.}
}
\value{
a filtered data frame
}
\description{
Filters a data frame for special cases. For example, find_duplicates() returns
all rows that are duplicates. If variables are passed to the function
then duplicates for those variables are returned.
}
\details{
irrational values are Inf and NaN
}
\examples{
\dontrun{
df <- data.frame(a = c("A", NA, "B", "C", "C"),
                 b = c(NA, 1, 1, 3, 3), 
                 c = c(7, 8, 2, 3, 3), 
                 stringsAsFactors = FALSE)

# Returns duplicated rows
df \%>\% find_duplicates()

# Returns duplicates in specific variables
df \%>\% find_duplicates(b:c)

# Returns rows where NA in variable b
df \%>\% find_na(b)
}

}
\seealso{
\code{vignette("s")}, \code{vignette("hablar")}

\code{\link{check_df}} to return TRUE or FALSE instead of rows.
}
