% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.dayOfWeek}
\alias{h2o.dayOfWeek}
\alias{dayOfWeek}
\alias{dayOfWeek.H2OFrame}
\title{Convert Milliseconds to Day of Week in H2O Datasets}
\usage{
h2o.dayOfWeek(x)

dayOfWeek(x)

\method{dayOfWeek}{H2OFrame}(x)
}
\arguments{
\item{x}{An H2OFrame object.}
}
\value{
An H2OFrame object containing the entries of \code{x} converted to days of
        the week.
}
\description{
Converts the entries of an H2OFrame object from milliseconds to days of the week
(on a 0 to 6 scale).
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/jira/v-11-eurodate.csv"
hdf <- h2o.importFile(f)
h2o.dayOfWeek(hdf["ds9"])
}
}
\seealso{
\code{\link{h2o.day}, \link{h2o.month}}
}
