% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.abs}
\alias{h2o.abs}
\title{Compute the absolute value of x}
\usage{
h2o.abs(x)
}
\arguments{
\item{x}{An H2OFrame object.}
}
\description{
Compute the absolute value of x
}
\examples{
\dontrun{
h2o.init()
url <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/smtrees.csv"
smtrees_hf <- h2o.importFile(url)
smtrees_df <- read.csv(
  "https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/smtrees.csv")
model <- h2o.gbm(x = c("girth", "height"), y = "vol", ntrees = 3, max_depth = 1,
                 distribution = "gaussian", min_rows = 2, learn_rate = .1,
                 training_frame = smtrees_hf)
pred <- as.data.frame(predict(model, newdata = smtrees_hf))
diff <- pred - smtrees_df[, 4]
diff_abs <- abs(diff)
print(diff_abs)
}
}
\seealso{
\code{\link[base]{abs}} for the base R implementation.
}
