# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_R.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details) 
#'
# -------------------------- XGBoost -------------------------- #
#' 
#' Build an eXtreme Gradient Boosting model
#' 
#' Builds a eXtreme Gradient Boosting model using the native XGBoost backend.
#' 
#' @param x (Optional) A vector containing the names or indices of the predictor variables to use in building the model.
#'        If x is missing, then all columns except y are used.
#' @param y The name or column index of the response variable in the data. The response must be either a numeric or a
#'        categorical/factor variable. If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.
#' @param model_id Destination id for this model; auto-generated if not specified.
#' @param training_frame Id of the training data frame.
#' @param validation_frame Id of the validation data frame.
#' @param nfolds Number of folds for K-fold cross-validation (0 to disable or >= 2). Defaults to 0.
#' @param keep_cross_validation_predictions \code{Logical}. Whether to keep the predictions of the cross-validation models. Defaults to FALSE.
#' @param keep_cross_validation_fold_assignment \code{Logical}. Whether to keep the cross-validation fold assignment. Defaults to FALSE.
#' @param score_each_iteration \code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.
#' @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will
#'        stratify the folds based on the response variable, for classification problems. Must be one of: "AUTO",
#'        "Random", "Modulo", "Stratified". Defaults to AUTO.
#' @param fold_column Column with cross-validation fold index assignment per observation.
#' @param ignore_const_cols \code{Logical}. Ignore constant columns. Defaults to TRUE.
#' @param offset_column Offset column. This will be added to the combination of columns before applying the link function.
#' @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from
#'        the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
#'        weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the
#'        data frame. This is typically the number of times a row is repeated, but non-integer values are supported as
#'        well. During training, rows with higher weights matter more, due to the larger loss function pre-factor.
#' @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
#'        stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) Defaults to 0.
#' @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) Must be one of:
#'        "AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE", "AUC", "lift_top_group", "misclassification",
#'        "mean_per_class_error". Defaults to AUTO.
#' @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this
#'        much) Defaults to 0.001.
#' @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.
#' @param seed Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default)
#'        Defaults to -1 (time-based random number).
#' @param distribution Distribution function Must be one of: "AUTO", "bernoulli", "multinomial", "gaussian", "poisson", "gamma",
#'        "tweedie", "laplace", "quantile", "huber". Defaults to AUTO.
#' @param tweedie_power Tweedie power for Tweedie regression, must be between 1 and 2. Defaults to 1.5.
#' @param categorical_encoding Encoding scheme for categorical features Must be one of: "AUTO", "Enum", "OneHotInternal", "OneHotExplicit",
#'        "Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited". Defaults to AUTO.
#' @param quiet_mode \code{Logical}. Enable quiet mode Defaults to TRUE.
#' @param ntrees (same as n_estimators) Number of trees. Defaults to 50.
#' @param max_depth Maximum tree depth. Defaults to 6.
#' @param min_rows (same as min_child_weight) Fewest allowed (weighted) observations in a leaf. Defaults to 1.
#' @param min_child_weight (same as min_rows) Fewest allowed (weighted) observations in a leaf. Defaults to 1.
#' @param learn_rate (same as eta) Learning rate (from 0.0 to 1.0) Defaults to 0.3.
#' @param eta (same as learn_rate) Learning rate (from 0.0 to 1.0) Defaults to 0.3.
#' @param sample_rate (same as subsample) Row sample rate per tree (from 0.0 to 1.0) Defaults to 1.
#' @param subsample (same as sample_rate) Row sample rate per tree (from 0.0 to 1.0) Defaults to 1.
#' @param col_sample_rate (same as colsample_bylevel) Column sample rate (from 0.0 to 1.0) Defaults to 1.
#' @param colsample_bylevel (same as col_sample_rate) Column sample rate (from 0.0 to 1.0) Defaults to 1.
#' @param col_sample_rate_per_tree (same as colsample_bytree) Column sample rate per tree (from 0.0 to 1.0) Defaults to 1.
#' @param colsample_bytree (same as col_sample_rate_per_tree) Column sample rate per tree (from 0.0 to 1.0) Defaults to 1.
#' @param max_abs_leafnode_pred (same as max_delta_step) Maximum absolute value of a leaf node prediction Defaults to 0.0.
#' @param max_delta_step (same as max_abs_leafnode_pred) Maximum absolute value of a leaf node prediction Defaults to 0.0.
#' @param score_tree_interval Score the model after every so many trees. Disabled if set to 0. Defaults to 0.
#' @param min_split_improvement (same as gamma) Minimum relative improvement in squared error reduction for a split to happen Defaults to 0.0.
#' @param gamma (same as min_split_improvement) Minimum relative improvement in squared error reduction for a split to happen
#'        Defaults to 0.0.
#' @param nthread Number of parallel threads that can be used to run XGBoost. Cannot exceed H2O cluster limits (-nthreads
#'        parameter). Defaults to maximum available Defaults to -1.
#' @param max_bins For tree_method=hist only: maximum number of bins Defaults to 256.
#' @param max_leaves For tree_method=hist only: maximum number of leaves Defaults to 0.
#' @param min_sum_hessian_in_leaf For tree_method=hist only: the mininum sum of hessian in a leaf to keep splitting Defaults to 100.0.
#' @param min_data_in_leaf For tree_method=hist only: the mininum data in a leaf to keep splitting Defaults to 0.0.
#' @param sample_type For booster=dart only: sample_type Must be one of: "uniform", "weighted". Defaults to uniform.
#' @param normalize_type For booster=dart only: normalize_type Must be one of: "tree", "forest". Defaults to tree.
#' @param rate_drop For booster=dart only: rate_drop (0..1) Defaults to 0.0.
#' @param one_drop \code{Logical}. For booster=dart only: one_drop Defaults to FALSE.
#' @param skip_drop For booster=dart only: skip_drop (0..1) Defaults to 0.0.
#' @param tree_method Tree method Must be one of: "auto", "exact", "approx", "hist". Defaults to auto.
#' @param grow_policy Grow policy - depthwise is standard GBM, lossguide is LightGBM Must be one of: "depthwise", "lossguide".
#'        Defaults to depthwise.
#' @param booster Booster type Must be one of: "gbtree", "gblinear", "dart". Defaults to gbtree.
#' @param reg_lambda L2 regularization Defaults to 0.0.
#' @param reg_alpha L1 regularization Defaults to 0.0.
#' @param dmatrix_type Type of DMatrix. For sparse, NAs and 0 are treated equally. Must be one of: "auto", "dense", "sparse".
#'        Defaults to auto.
#' @param backend Backend. By default (auto), a GPU is used if available. Must be one of: "auto", "gpu", "cpu". Defaults to
#'        auto.
#' @param gpu_id Which GPU to use.  Defaults to 0.
#' @param verbose \code{Logical}. Print scoring history to the console (Metrics per tree for GBM, DRF, & XGBoost. Metrics per epoch for Deep Learning). Defaults to FALSE.
#' @export
h2o.xgboost <- function(x, y, training_frame,
                        model_id = NULL,
                        validation_frame = NULL,
                        nfolds = 0,
                        keep_cross_validation_predictions = FALSE,
                        keep_cross_validation_fold_assignment = FALSE,
                        score_each_iteration = FALSE,
                        fold_assignment = c("AUTO", "Random", "Modulo", "Stratified"),
                        fold_column = NULL,
                        ignore_const_cols = TRUE,
                        offset_column = NULL,
                        weights_column = NULL,
                        stopping_rounds = 0,
                        stopping_metric = c("AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE", "AUC", "lift_top_group", "misclassification", "mean_per_class_error"),
                        stopping_tolerance = 0.001,
                        max_runtime_secs = 0,
                        seed = -1,
                        distribution = c("AUTO", "bernoulli", "multinomial", "gaussian", "poisson", "gamma", "tweedie", "laplace", "quantile", "huber"),
                        tweedie_power = 1.5,
                        categorical_encoding = c("AUTO", "Enum", "OneHotInternal", "OneHotExplicit", "Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited"),
                        quiet_mode = TRUE,
                        ntrees = 50,
                        max_depth = 6,
                        min_rows = 1,
                        min_child_weight = 1,
                        learn_rate = 0.3,
                        eta = 0.3,
                        sample_rate = 1,
                        subsample = 1,
                        col_sample_rate = 1,
                        colsample_bylevel = 1,
                        col_sample_rate_per_tree = 1,
                        colsample_bytree = 1,
                        max_abs_leafnode_pred = 0.0,
                        max_delta_step = 0.0,
                        score_tree_interval = 0,
                        min_split_improvement = 0.0,
                        gamma = 0.0,
                        nthread = -1,
                        max_bins = 256,
                        max_leaves = 0,
                        min_sum_hessian_in_leaf = 100.0,
                        min_data_in_leaf = 0.0,
                        sample_type = c("uniform", "weighted"),
                        normalize_type = c("tree", "forest"),
                        rate_drop = 0.0,
                        one_drop = FALSE,
                        skip_drop = 0.0,
                        tree_method = c("auto", "exact", "approx", "hist"),
                        grow_policy = c("depthwise", "lossguide"),
                        booster = c("gbtree", "gblinear", "dart"),
                        reg_lambda = 0.0,
                        reg_alpha = 0.0,
                        dmatrix_type = c("auto", "dense", "sparse"),
                        backend = c("auto", "gpu", "cpu"),
                        gpu_id = 0,
                        verbose = FALSE 
                        ) 
{
  # If x is missing, then assume user wants to use all columns as features.
  if (missing(x)) {
     if (is.numeric(y)) {
         x <- setdiff(col(training_frame), y)
     } else {
         x <- setdiff(colnames(training_frame), y)
     }
  }

  # Required args: training_frame
  if (missing(training_frame)) stop("argument 'training_frame' is missing, with no default")
  # Training_frame must be a key or an H2OFrame object
  if (!is.H2OFrame(training_frame))
     tryCatch(training_frame <- h2o.getFrame(training_frame),
           error = function(err) {
             stop("argument 'training_frame' must be a valid H2OFrame or key")
           })
  # Validation_frame must be a key or an H2OFrame object
  if (!is.null(validation_frame)) {
     if (!is.H2OFrame(validation_frame))
         tryCatch(validation_frame <- h2o.getFrame(validation_frame),
             error = function(err) {
                 stop("argument 'validation_frame' must be a valid H2OFrame or key")
             })
  }
  # Parameter list to send to model builder
  parms <- list()
  parms$training_frame <- training_frame
  args <- .verify_dataxy(training_frame, x, y)
  if( !missing(offset_column) && !is.null(offset_column))  args$x_ignore <- args$x_ignore[!( offset_column == args$x_ignore )]
  if( !missing(weights_column) && !is.null(weights_column)) args$x_ignore <- args$x_ignore[!( weights_column == args$x_ignore )]
  if( !missing(fold_column) && !is.null(fold_column)) args$x_ignore <- args$x_ignore[!( fold_column == args$x_ignore )]
  parms$ignored_columns <- args$x_ignore
  parms$response_column <- args$y

  if (!missing(model_id))
    parms$model_id <- model_id
  if (!missing(validation_frame))
    parms$validation_frame <- validation_frame
  if (!missing(nfolds))
    parms$nfolds <- nfolds
  if (!missing(keep_cross_validation_predictions))
    parms$keep_cross_validation_predictions <- keep_cross_validation_predictions
  if (!missing(keep_cross_validation_fold_assignment))
    parms$keep_cross_validation_fold_assignment <- keep_cross_validation_fold_assignment
  if (!missing(score_each_iteration))
    parms$score_each_iteration <- score_each_iteration
  if (!missing(fold_assignment))
    parms$fold_assignment <- fold_assignment
  if (!missing(fold_column))
    parms$fold_column <- fold_column
  if (!missing(ignore_const_cols))
    parms$ignore_const_cols <- ignore_const_cols
  if (!missing(offset_column))
    parms$offset_column <- offset_column
  if (!missing(weights_column))
    parms$weights_column <- weights_column
  if (!missing(stopping_rounds))
    parms$stopping_rounds <- stopping_rounds
  if (!missing(stopping_metric))
    parms$stopping_metric <- stopping_metric
  if (!missing(stopping_tolerance))
    parms$stopping_tolerance <- stopping_tolerance
  if (!missing(max_runtime_secs))
    parms$max_runtime_secs <- max_runtime_secs
  if (!missing(seed))
    parms$seed <- seed
  if (!missing(distribution))
    parms$distribution <- distribution
  if (!missing(tweedie_power))
    parms$tweedie_power <- tweedie_power
  if (!missing(categorical_encoding))
    parms$categorical_encoding <- categorical_encoding
  if (!missing(quiet_mode))
    parms$quiet_mode <- quiet_mode
  if (!missing(ntrees))
    parms$ntrees <- ntrees
  if (!missing(max_depth))
    parms$max_depth <- max_depth
  if (!missing(min_rows))
    parms$min_rows <- min_rows
  if (!missing(min_child_weight))
    parms$min_child_weight <- min_child_weight
  if (!missing(learn_rate))
    parms$learn_rate <- learn_rate
  if (!missing(eta))
    parms$eta <- eta
  if (!missing(sample_rate))
    parms$sample_rate <- sample_rate
  if (!missing(subsample))
    parms$subsample <- subsample
  if (!missing(col_sample_rate))
    parms$col_sample_rate <- col_sample_rate
  if (!missing(colsample_bylevel))
    parms$colsample_bylevel <- colsample_bylevel
  if (!missing(col_sample_rate_per_tree))
    parms$col_sample_rate_per_tree <- col_sample_rate_per_tree
  if (!missing(colsample_bytree))
    parms$colsample_bytree <- colsample_bytree
  if (!missing(max_abs_leafnode_pred))
    parms$max_abs_leafnode_pred <- max_abs_leafnode_pred
  if (!missing(max_delta_step))
    parms$max_delta_step <- max_delta_step
  if (!missing(score_tree_interval))
    parms$score_tree_interval <- score_tree_interval
  if (!missing(min_split_improvement))
    parms$min_split_improvement <- min_split_improvement
  if (!missing(gamma))
    parms$gamma <- gamma
  if (!missing(nthread))
    parms$nthread <- nthread
  if (!missing(max_bins))
    parms$max_bins <- max_bins
  if (!missing(max_leaves))
    parms$max_leaves <- max_leaves
  if (!missing(min_sum_hessian_in_leaf))
    parms$min_sum_hessian_in_leaf <- min_sum_hessian_in_leaf
  if (!missing(min_data_in_leaf))
    parms$min_data_in_leaf <- min_data_in_leaf
  if (!missing(sample_type))
    parms$sample_type <- sample_type
  if (!missing(normalize_type))
    parms$normalize_type <- normalize_type
  if (!missing(rate_drop))
    parms$rate_drop <- rate_drop
  if (!missing(one_drop))
    parms$one_drop <- one_drop
  if (!missing(skip_drop))
    parms$skip_drop <- skip_drop
  if (!missing(tree_method))
    parms$tree_method <- tree_method
  if (!missing(grow_policy))
    parms$grow_policy <- grow_policy
  if (!missing(booster))
    parms$booster <- booster
  if (!missing(reg_lambda))
    parms$reg_lambda <- reg_lambda
  if (!missing(reg_alpha))
    parms$reg_alpha <- reg_alpha
  if (!missing(dmatrix_type))
    parms$dmatrix_type <- dmatrix_type
  if (!missing(backend))
    parms$backend <- backend
  if (!missing(gpu_id))
    parms$gpu_id <- gpu_id
  # Error check and build model
  .h2o.modelJob('xgboost', parms, h2oRestApiVersion = 3, verbose=verbose) 
}

#' Determines whether an XGBoost model can be built
#'
#' Ask the H2O server whether a XGBoost model can be built. (Depends on availability of native backend.)
#' Returns True if a XGBoost model can be built, or False otherwise.
#' @export
h2o.xgboost.available <- function() {
if (!("XGBoost" %in% h2o.list_core_extensions())) {
print("Cannot build a XGboost model - no backend found.")
return(FALSE)
} else {
return(TRUE)
}
}

