% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/kvstore.R
\name{h2o.getModel}
\alias{h2o.getModel}
\title{Get an R reference to an H2O model}
\usage{
h2o.getModel(model_id)
}
\arguments{
\item{model_id}{A string indicating the unique model_id of the model to retrieve.}
}
\value{
Returns an object that is a subclass of \linkS4class{H2OModel}.
}
\description{
Returns a reference to an existing model in the H2O instance.
}
\examples{
\donttest{
library(h2o)
h2o.init()

iris.hex <- as.h2o(iris, "iris.hex")
model_id <- h2o.gbm(x = 1:4, y = 5, training_frame = iris.hex)@model_id
model.retrieved <- h2o.getModel(model_id)
}
}

