\name{h2o.insertMissingValues}
\alias{h2o.insertMissingValues}

\title{
Replace Entries in H2O Data Set with Missing Value
}
\description{
Replaces a user-specified fraction of entries in a H2O dataset with missing values.
}
\usage{
  h2o.insertMissingValues(data, fraction = 0.01, seed = -1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{An \code{\linkS4class{H2OParsedData}} object representing the dataset.}
  \item{fraction}{A number between 0 and 1 indicating the fraction of entries to replace with missing values.}
  \item{seed}{A random number used to select which entries to replace with missing values. If \code{seed = -1}, one will automatically be generated by H2O.}
}
\details{
This method modifies the input dataset in place.
}
\value{
Returns an \code{\linkS4class{H2OParsedData}} object that represents the dataset with missing values inserted.
}
\examples{
\dontrun{
library(h2o)
localH2O = h2o.init()
irisPath = system.file("extdata", "iris.csv", package = "h2o")
iris.hex = h2o.importFile(localH2O, path = irisPath)
summary(iris.hex)
iris.hex = h2o.insertMissingValues(iris.hex, fraction = 0.25)
head(iris.hex)
summary(iris.hex)
}
}
