% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-utils.R
\name{is_human_chromosome}
\alias{is_human_chromosome}
\title{Is a string a human chromosome name?}
\usage{
is_human_chromosome(
  string,
  chromosomes = c(seq_len(22), "X", "Y", "MT"),
  convert_NA_to_FALSE = TRUE
)
}
\arguments{
\item{string}{A character vector of strings.}

\item{chromosomes}{A character vector of valid chromosome names. Default is
autosomal chromosomes 1 thru 22 and, X, Y, and MT.}

\item{convert_NA_to_FALSE}{Whether to treat \code{NA} as \code{NA}
(\code{convert_NA_to_FALSE = FALSE}) or whether to return \code{FALSE} when
an \code{NA} is found (\code{convert_NA_to_FALSE = TRUE}).}
}
\value{
A logical vector.
}
\description{
Find which strings are valid human chromosome names. The valid chromosome
names can be specified via the argument \code{chromosomes}.
}
\keyword{internal}
