% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_means.R
\name{plot_means}
\alias{plot_means}
\title{Plot means by sub-groups}
\usage{
plot_means(
  data,
  outcome,
  by = NULL,
  drop_na_by = FALSE,
  convert_continuous = TRUE,
  geom = "point",
  ...,
  show_overall = TRUE,
  overall_label = "Overall",
  show_ci = TRUE,
  conf_level = 0.95,
  ci_color = "black",
  show_pvalues = TRUE,
  pvalues_labeller = scales::label_pvalue(add_p = TRUE),
  pvalues_size = 3.5,
  show_labels = TRUE,
  label_y = NULL,
  labels_labeller = scales::label_number(0.1),
  labels_size = 3.5,
  labels_color = "black",
  show_overall_line = FALSE,
  overall_line_type = "dashed",
  overall_line_color = "black",
  overall_line_width = 0.5,
  facet_labeller = ggplot2::label_wrap_gen(width = 50, multi_line = TRUE),
  flip = FALSE,
  minimal = FALSE,
  free_scale = FALSE,
  return_data = FALSE
)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble),
or a survey design object.}

\item{outcome}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> List of
continuous variables to be plotted.}

\item{by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> List of variables to
group by (comparison is done separately for each variable).}

\item{drop_na_by}{Remove \code{NA} values in \code{by} variables?}

\item{convert_continuous}{Should continuous by variables (with 5 unique
values or more) be converted to quartiles (using \code{cut_quartiles()})?}

\item{geom}{Geometry to use for plotting means (\code{"point"} by default).}

\item{...}{Additional arguments passed to the geom defined by \code{geom}.}

\item{show_overall}{Display "Overall" column?}

\item{overall_label}{Label for the overall column.}

\item{show_ci}{Display confidence intervals?}

\item{conf_level}{Confidence level for the confidence intervals.}

\item{ci_color}{Color of the error bars representing confidence intervals.}

\item{show_pvalues}{Display p-values in the top-left corner? p-values are
computed with \code{\link[stats:oneway.test]{stats::oneway.test()}} for data frames, and with
\code{\link[survey:svyttest]{survey::svyttest()}} (2 groups) or \code{\link[=svyoneway]{svyoneway()}} (3 groups or more)
for survey objects.}

\item{pvalues_labeller}{Labeller function for p-values.}

\item{pvalues_size}{Text size for p-values.}

\item{show_labels}{Display mean labels?}

\item{label_y}{Y position of labels. If \code{NULL}, will be auto-determined.}

\item{labels_labeller}{Labeller function for labels.}

\item{labels_size}{Size of labels.}

\item{labels_color}{Color of labels.}

\item{show_overall_line}{Add an overall line?}

\item{overall_line_type}{Line type of the overall line.}

\item{overall_line_color}{Color of the overall line.}

\item{overall_line_width}{Line width of the overall line.}

\item{facet_labeller}{Labeller function for strip labels.}

\item{flip}{Flip x and y axis?}

\item{minimal}{Should a minimal theme be applied? (no y-axis, no grid)}

\item{free_scale}{Allow y axis to vary between conditions?}

\item{return_data}{Return computed data instead of the plot?}
}
\description{
Plot one or several means by sub-groups. See \code{\link[=mean_sd]{mean_sd()}} for more details on
the way means and confidence intervals are computed.
By default, return a point plot, but other geometries could be used
(see examples).
}
\examples{
iris |>
  plot_means(Petal.Length, by = Species)

iris |>
  plot_means(
    dplyr::starts_with("Petal"),
    by = Species,
    geom = "bar",
    fill = "lightblue",
    show_overall_line = TRUE
  )

\donttest{

mtcars |>
  plot_means(
    mpg,
    by = c(cyl, gear),
    size = 3,
    colour = "plum",
    flip = TRUE
  )

# works with continuous by variables
mtcars |>
  plot_means(
    mpg,
    by = c(disp, drat),
    fill = "plum",
    geom = "bar",
    flip = TRUE,
    minimal = TRUE
  )

# works with survey object
iris |>
  srvyr::as_survey() |>
  plot_means(
    Petal.Length,
    by = c(Species, Petal.Width),
    label_y = -1,
    size = 3,
    mapping = ggplot2::aes(colour = by),
    flip = TRUE
  )
}
}
\keyword{hplot}
