% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/median_iqr.R
\name{median_iqr}
\alias{median_iqr}
\alias{median_iqr.data.frame}
\alias{median_iqr.survey.design}
\alias{median_iqr.default}
\title{Compute median, quartiles and interquartile range by sub-groups}
\usage{
median_iqr(data, ...)

\method{median_iqr}{data.frame}(
  data,
  ...,
  .by = NULL,
  .drop = FALSE,
  .drop_na_by = FALSE,
  .outliers = FALSE
)

\method{median_iqr}{survey.design}(
  data,
  ...,
  .by = NULL,
  .drop = FALSE,
  .drop_na_by = FALSE,
  .outliers = FALSE
)

\method{median_iqr}{default}(data, ..., .drop = FALSE, .outliers = FALSE)
}
\arguments{
\item{data}{A vector, a data frame, data frame extension (e.g. a tibble),
or a survey design object.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variable(s) for which
to compute median, quartiles and interquartile range.}

\item{.by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optional additional
variables to group by (in addition to those eventually previously declared
using \code{\link[dplyr:group_by]{dplyr::group_by()}}).}

\item{.drop}{If \code{TRUE}, will remove empty groups from the output.}

\item{.drop_na_by}{If \code{TRUE}, will remove any \code{NA} values observed in the
\code{.by} variables (or variables defined with \code{\link[dplyr:group_by]{dplyr::group_by()}}).}

\item{.outliers}{If \code{TRUE}, will estimate whiskers and outliers.}
}
\value{
A tibble. Column \code{"n"} reports the number of valid observations
and \code{"missing"} the number of missing (\code{NA}) observations, unweighted for
survey objects.

A tibble with one row per group.
}
\description{
\code{median_iqr()} lets you quickly compute median, quartiles and interquartile
range by sub-groups. Use \code{.outliers = TRUE} to also return whiskers and
outliers (see \code{\link[ggplot2:geom_boxplot]{ggplot2::stat_boxplot()}}).
}
\examples{
# using a vector
iris$Petal.Length |> median_iqr()

# one variable
iris |> median_iqr(Petal.Length)
iris |> median_iqr(Petal.Length, .outliers = TRUE)
iris |> median_iqr(Petal.Length, .by = Species)
mtcars |> median_iqr(mpg, .by = c(cyl, gear))

# two variables
iris |> median_iqr(Petal.Length, Petal.Width)
iris |> median_iqr(dplyr::pick(dplyr::starts_with("Petal")), .by = Species)

# missing values
d <- iris
d$Petal.Length[1:10] <- NA
d |> median_iqr(Petal.Length)
d |> median_iqr(Petal.Length, .by = Species)

\donttest{
## SURVEY DATA ------------------------------------------------------

ds <- srvyr::as_survey(iris)
ds |> median_iqr(Petal.Length, .by = Species, .outliers = TRUE)
}
}
\keyword{univar}
