% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{gu_tags}
\alias{gu_tags}
\title{Tags}
\usage{
gu_tags(query = NULL, tag_type = NULL, section = NULL,
  references = NULL, reference_type = NULL, show_references = "all",
  ..., verbose = TRUE, tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{query}{A string, which will return all tags containing that string.}

\item{tag_type}{One of "\code{keyword}", "\code{series}", "\code{contributor}",
"\code{tone}", "\code{type}" or "\code{blog}". Defaults to \code{NULL} and does not filter by
tag type.}

\item{section}{Return only tags of a given section.}

\item{references}{Return only tags with those references}

\item{reference_type}{Return only tags with those reference types.}

\item{show_references}{Show associated reference data such as ISBNs.
Defaults to \code{"all"} and shows all available references. Accepts character
vectors of one or more references (see details for options).}

\item{...}{Use to pass any other parameters to the API. See the
\href{https://open-platform.theguardian.com/documentation/tag}{docs} for a
full list of options.}

\item{verbose}{Prints messages to console. Defaults to \code{TRUE}.}

\item{tidy}{Convert variable names to snake_case, remove some \code{"<NA>"}
strings. Defaults to \code{TRUE}.}

\item{tidy_style}{Style to variable names with.}
}
\value{
A tibble with details on tags.
}
\description{
All the tags used on the Guardian website. See the
\href{https://open-platform.theguardian.com/documentation/tag}{API docs} on this
endpoint for more details.
}
\section{References options}{


The following are the options for the \code{show_references} parameter:
\itemize{
\item "\code{all}" Includes all the fields (default)
\item "\code{author}"
\item "\code{bisac-prefix}"
\item "\code{esa-cricket-match}"
\item "\code{esa-football-match}"
\item "\code{esa-football-team}"
\item "\code{esa-football-tournament}"
\item "\code{isbn}"
\item "\code{imdb}"
\item "\code{musicbrainz}"
\item "\code{musicbrainzgenre}"
\item "\code{opta-cricket-match}"
\item "\code{opta-football-match}"
\item "\code{opta-football-team}"
\item "\code{opta-football-tournament}"
\item "\code{pa-football-competition}"
\item "\code{pa-football-match}"
\item "\code{pa-football-team}"
\item "\code{r1-film}"
\item "\code{reuters-index-ric}"
\item "\code{reuters-stock-ric}"
\item "\code{witness-assignment}"
}
}

\examples{
\dontrun{
# Return all tags containing "apple"
apple1 <- gu_tags(query = "apple")

# Return all tags containing "apple" in the technology section
apple2 <- gu_tags(query = "apple", section = "technology")

# Return all contributor tags in the life and style section
tag_sec_type <- gu_tags(section = "lifeandstyle", tag_type = "contributor")
}

}
