% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_nevent.R
\name{add_nevent.tbl_regression}
\alias{add_nevent.tbl_regression}
\title{Add number of events to a regression table}
\usage{
\method{add_nevent}{tbl_regression}(x, ...)
}
\arguments{
\item{x}{\code{tbl_regression} object}

\item{...}{Not used}
}
\value{
A \code{tbl_regression} object
}
\description{
This function adds a column of the number of events to tables created with
\link{tbl_regression}.  Supported
model types include GLMs with binomial distribution family (e.g.
\link[stats:glm]{stats::glm}, \link[lme4:glmer]{lme4::glmer}, and
\link[geepack:geeglm]{geepack::geeglm}) and Cox
Proportion Hazards regression models (\link[survival:coxph]{survival::coxph}).
}
\section{Reporting Event N}{

The number of events is added to the internal \code{.$table_body} tibble,
and not printed in the default output table (similar to N). The number
of events is accessible via the \link{inline_text} function for printing in a report.
}

\section{Example Output}{

\if{html}{\figure{tbl_reg_nevent_ex.png}{options: width=50\%}}
}

\examples{
tbl_reg_nevent_ex <-
  glm(response ~ trt, trial, family = binomial) \%>\%
  tbl_regression() \%>\%
  add_nevent()
}
\seealso{
Other tbl_regression tools: 
\code{\link{add_global_p.tbl_regression}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{bold_p.tbl_regression}()},
\code{\link{bold_p.tbl_stack}()},
\code{\link{inline_text.tbl_regression}()},
\code{\link{modify_header}()},
\code{\link{sort_p.tbl_regression}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_regression}()},
\code{\link{tbl_stack}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
