% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectors.R
\name{selectors}
\alias{selectors}
\alias{all_ae_cols}
\alias{all_cols_in_strata}
\alias{all_overall_cols}
\alias{all_unknown_cols}
\title{Column Selectors}
\usage{
all_ae_cols(overall = FALSE, unknown = FALSE)

all_cols_in_strata(strata)

all_overall_cols()

all_unknown_cols()
}
\arguments{
\item{overall}{logical indicating whether to include the overall columns.
Default is FALSE}

\item{unknown}{logical indicating whether to include the unknown or missing columns.
Default is FALSE}

\item{strata}{character vector of the selected stratum}
}
\value{
selected columns
}
\description{
\itemize{
\item \code{all_ae_cols(overall, unknown)} selects all columns summarizing AE statistics. By default, unknown and overall columns are not selected.
\item \code{all_cols_in_strata(strata)} selects all columns from specified stratum.
\item \code{all_overall_cols()} selects all overall columns
\item \code{all_unknown_cols()} selects all unknown columns
}
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{selectors_ex1.png}{options: width=65\%}}
}

\examples{
\donttest{
selectors_ex1 <-
  df_adverse_events \%>\%
  dplyr::mutate(grade = ifelse(dplyr::row_number() == 1L, NA, grade)) \%>\%
  tbl_ae(
    id = patient_id,
    ae = adverse_event,
    soc = system_organ_class,
    by = grade
  ) \%>\%
  add_overall(across = 'by') \%>\%
  modify_header(
    all_ae_cols() ~ "**Grade {by}**",
    all_overall_cols() ~ "**Total**",
    all_unknown_cols() ~ "**Unknown Grade**"
  )
}
}
\seealso{
\code{gtsummary::all_stat_cols()}
}
