% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfers.R
\name{gtfs_transfer_table}
\alias{gtfs_transfer_table}
\title{gtfs_transfer_table}
\usage{
gtfs_transfer_table(
  gtfs,
  d_limit = 200,
  min_transfer_time = 120,
  network = NULL,
  network_times = FALSE
)
}
\arguments{
\item{gtfs}{A GTFS feed obtained from the \link{extract_gtfs} function.}

\item{d_limit}{Upper straight-line distance limit in metres for transfers.}

\item{min_transfer_time}{Minimum time in seconds for transfers; all values
below this will be replaced with this value, particularly all those defining
in-place transfers where stop longitudes and latitudes remain identical.}

\item{network}{Optional Open Street Map representation of the street network
encompassed by the GTFS feed (see Examples).}

\item{network_times}{If \code{TRUE}, transfer times are calculated by routing
throughout the underlying street network. If this is not provided as the
\code{net} parameter, it will be automatically downloaded.}
}
\value{
Modified version of the \code{gtfs} input with additional transfers table.
}
\description{
Construct a transfer table for a GTFS feed.
}
\examples{
# Use the following lines to extract a street network for a given GTFS feed.
# The result can then be passed as the `network` parameter.
\dontrun{
library (dodgr)
net <- dodgr_streetnet_sc (pts = gtfs$stops [, c ("stop_lon", "stop_lat")])
}
}
