% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_exons.R
\name{get_exons}
\alias{get_exons}
\title{Get Exons}
\usage{
get_exons(
  gencodeId,
  gencodeVersion = NULL,
  genomeBuild = NULL,
  datasetId = "gtex_v8",
  page = 0,
  itemsPerPage = 250
)
}
\arguments{
\item{gencodeId}{String. A Versioned GENCODE ID of a gene, e.g.
"ENSG00000065613.9".}

\item{gencodeVersion}{String (default = "v26"). GENCODE annotation release.
Either "v26" or "v19".}

\item{genomeBuild}{String. Options: "GRCh38/hg38", "GRCh37/hg19". Default =
"GRCh38/hg38".}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250).}
}
\value{
A tibble.
}
\description{
This service returns exons from all known transcripts of the given gene.
\itemize{
\item A versioned GENCODE ID is required to ensure that all exons are from a single gene.
\item A dataset ID or both GENCODE version and genome build must be provided.
\item Although annotated exons are not dataset dependent, specifying a dataset here is equivalent to specifying the GENCODE version and genome build used by that dataset.
}

\href{https://gtexportal.org/api/v2/redoc#tag/Reference-Genome-Endpoints/operation/get_exons_api_v2_reference_exon_get}{GTEx Portal API documentation}
}
\examples{
\dontrun{
get_exons(gencodeId = "ENSG00000203782.5")
}
}
\seealso{
Other Reference Genome Endpoints: 
\code{\link{get_gene_search}()},
\code{\link{get_genes}()},
\code{\link{get_genomic_features}()},
\code{\link{get_gwas_catalog_by_location}()},
\code{\link{get_neighbor_gene}()},
\code{\link{get_transcripts}()}
}
\concept{Reference Genome Endpoints}
