% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{default_fonts}
\alias{default_fonts}
\title{A vector of default fonts for use with \strong{gt} tables}
\usage{
default_fonts()
}
\value{
A character vector of font names.
}
\description{
The vector of fonts given by \code{default_fonts()} should be used with a \strong{gt}
table that is rendered to HTML. We can specify additional fonts to use but
this default set should be placed after that to act as fallbacks. This is
useful when specifying \code{font} values in the \code{\link[=cell_text]{cell_text()}} function (itself
used in the \code{\link[=tab_style]{tab_style()}} function). If using \code{\link[=opt_table_font]{opt_table_font()}} (which also
has a \code{font} argument) we probably don't need to specify this vector of fonts
since it is handled by its \code{add} option (which is \code{TRUE} by default).
}
\section{Figures}{

\if{html}{\figure{man_default_fonts_1.png}{options: width=100\%}}
}

\section{Function ID}{

7-19
}

\examples{
# Use `exibble` to create a gt table;
# attempting to modify the fonts used
# for the `time` column is much safer
# if `default_fonts()` is appended to
# the end of the `font` listing in the
# `cell_text()` call (the "Comic Sansa"
# and "Menloa" fonts don't exist, but,
# we'll get the first available font
# from the `default_fonts()` set)
tab_1 <-
  exibble \%>\%
  dplyr::select(char, time) \%>\%
  gt() \%>\%
  tab_style(
    style = cell_text(
      font = c(
        "Comic Sansa", "Menloa",
        default_fonts()
      )
    ),
    locations = cells_body(columns = vars(time))
  )

}
\seealso{
Other Helper Functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{escape_latex}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()}
}
\concept{Helper Functions}
