% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{fmt_time}
\alias{fmt_time}
\title{Format values as times}
\usage{
fmt_time(data, columns, rows = NULL, time_style = 2)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns to format. Can either be a series of column names
provided in \code{\link[=vars]{vars()}}, a vector of column indices, or a helper function
focused on selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, and \code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows to format. Not providing any value results in all
rows in \code{columns} being formatted. Can either be a vector of row captions
provided \code{\link[=c]{c()}}, a vector of row indices, or a helper function focused on
selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, and \code{\link[=everything]{everything()}}.
We can also use expressions to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{time_style}{The time style to use. Supply a number (from \code{1} to \code{5})
that corresponds to the preferred time style. Use \code{\link[=info_time_style]{info_time_style()}} to
see the different numbered and named time presets.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Format input time values that are character-based and expressed according to
the ISO 8601 time format (\code{HH:MM:SS}). Once the appropriate data cells are
targeted with \code{columns} (and, optionally, \code{rows}), we can simply apply a
preset time style to format the times. The following time styles are
available for simpler formatting of ISO times (all using the input time of
\code{14:35:00} in the example output times):
\enumerate{
\item hms: \code{14:35:00}
\item hm: \code{14:35}
\item hms_p: \verb{2:35:00 PM}
\item hm_p: \verb{2:35 PM}
\item h_p: \verb{2 PM}
}
We can use the \code{\link[=info_time_style]{info_time_style()}} function for a useful reference on all of
the possible inputs to \code{time_style}.
}
\details{
Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). A number of
helper functions exist to make targeting more effective. Conditional
formatting is possible by providing a conditional expression to the \code{rows}
argument. See the Arguments section for more information on this.
}
\section{Figures}{

\if{html}{\figure{man_fmt_time_1.png}{options: width=100\%}}

\if{html}{\figure{man_fmt_time_2.png}{options: width=100\%}}
}

\section{Function ID}{

3-6
}

\examples{
# Use `exibble` to create a gt table;
# keep only the `date` and `time` columns;
# format the `time` column to have
# times formatted as `hms_p`
# (time style `3`)
tab_1 <-
  exibble \%>\%
  dplyr::select(date, time) \%>\%
  gt() \%>\%
  fmt_time(
    columns = vars(time),
    time_style = 3
  )

# Use `exibble` to create a gt table;
# keep only the `date` and `time` columns;
# format the `time` column to have mixed
# time formats (times after 16:00 will
# be different than the others)
tab_2 <-
  exibble \%>\%
  dplyr::select(date, time) \%>\%
  gt() \%>\%
  fmt_time(
    columns = vars(time),
    rows =
      time > "16:00",
    time_style = 3
  ) \%>\%
  fmt_time(
    columns = vars(time),
    rows =
      time <= "16:00",
    time_style = 4
  )

}
\seealso{
Other Format Data: 
\code{\link{data_color}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_date}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_missing}()},
\code{\link{fmt_number}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt}()},
\code{\link{text_transform}()}
}
\concept{Format Data}
