% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_latentheat_evap_t}
\alias{gsw_latentheat_evap_t}
\title{Latent heat of evaporation}
\usage{
gsw_latentheat_evap_t(SA, t)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{t}{in-situ temperature (ITS-90) [ degC ]}
}
\value{
latent heat of evaporation [ J/kg ]
}
\description{
Latent heat of evaporation
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
t <- c( 28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
lh = gsw_latentheat_evap_t(SA, t)
stopifnot(all.equal(lh/1e6, c(2.429882982734836, 2.430730236218543, 2.444217294049004,
                              2.474137411322517, 2.482156276375029, 2.488054617630297)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_latentheat_evap_t.html}
}
\seealso{
Other things related to latent heat: 
\code{\link{gsw_latentheat_evap_CT}()},
\code{\link{gsw_latentheat_melting}()}
}
\concept{things related to latent heat}
