% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pt_from_t}
\alias{gsw_pt_from_t}
\title{Potential Temperature from in-situ Temperature}
\usage{
gsw_pt_from_t(SA, t, p, p_ref = 0)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{p_ref}{reference pressure [ dbar ]}
}
\value{
potential temperature [ degC ]
}
\description{
Potential Temperature from in-situ Temperature
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
t <- c( 28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <- c(      10,      50,     125,     250,     600,    1000)
p_ref <- 0
pt <- gsw_pt_from_t(SA, t, p, p_ref)
expect_equal(pt, c(28.783196819670632, 28.420983342398962, 22.784930399117108,
                   10.230523661095731, 6.829230224409661, 4.324510571845719))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pt_from_t.html}
}
