% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_melting_ice_SA_CT_ratio}
\alias{gsw_melting_ice_SA_CT_ratio}
\title{Calculate d(SA)/d(CT) for Ice Melting in Seawater}
\usage{
gsw_melting_ice_SA_CT_ratio(SA, CT, p, t_Ih)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{t_Ih}{initial temperature of ice [ degC ]}
}
\value{
ratio of change in \code{SA} to change in \code{CT} [ g/kg/degC ].
}
\description{
Calculate d(SA)/d(CT) for Ice Melting in Seawater
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(   34.7118,  34.8915,  35.0256,  34.8472,  34.7366, 34.7324)
CT <- c(    3.7856,   3.4329,   2.8103,   1.2600,   0.6886,  0.4403)
p <- c(         10,       50,      125,      250,      600,    1000)
t_Ih <- c(-10.7856, -13.4329, -12.8103, -12.2600, -10.8863, -8.4036)
r <- gsw_melting_ice_SA_CT_ratio(SA, CT, p, t_Ih)
expect_equal(r, c(0.373840909022490, 0.371878514972099, 0.377104664622191,
                0.382777696796156, 0.387133845152000, 0.393947316026914))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_melting_ice_SA_CT_ratio.html}
}
