\name{locus}
\alias{locus}
\title{General constructor for locus object}
\usage{
locus(x, type, phased = FALSE)
}
\arguments{
  \item{x}{The data to be turned into a \code{locus}
  object}

  \item{type}{An indication of what kind of data it is.  By
  default this parameter is missing and this will cause the
  function to assume that every element of x is an allele
  in the genotype.  \describe{ \item{blank}{Default value,
  uses all passed items as alleles} \item{aflp}{Encoded as
  0,1 for absence/presence of bands.} \item{column}{Two
  columns of alleles} \item{separated}{Pre-separated
  alleles (with ':').} \item{snp}{Encoded by the number of
  minor alleles at the locus.} \item{zyme}{Alleles like
  zymes (e.g., 12 for '1' and '2' alleles).} }}

  \item{phased}{A flag indicating the the alleles should
  are of known gametic phase (default=FALSE).}
}
\value{
Either a single or vector of objects of type \code{locus}.
}
\description{
This function creates an object of type \code{locus}, a
fundamental type in the gstudio package.  Therea re several
kinds of loci that can be created.
}
\examples{
AA <- locus( c("A","A") )
AB <- locus( c("A","B") )
BB <- locus( c("B","B") )
AC <- locus( c("A","C") )
AD <- locus( c("A","D") )
BC <- locus( c("B","C") )
BD <- locus( c("B","D") )
CC <- locus( c("C","C") )
CD <- locus( c("C","D") )
DD <- locus( c("D","D") )
loci <- c(AA,AB,AC,AD,BB,BC,BD,CC,CD,DD)
loci
}
\author{
Rodney J. Dyer \email{rjdyer@vcu.edu}
}

