% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls-methods.R
\name{summary.gsl_nls}
\alias{summary.gsl_nls}
\title{Model summary}
\usage{
\method{summary}{gsl_nls}(object, correlation = FALSE, symbolic.cor = FALSE, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{correlation}{logical; if \code{TRUE}, the correlation matrix of the estimated
parameters is returned and printed.}

\item{symbolic.cor}{logical; if \code{TRUE}, print the correlations in a symbolic form
(see \code{\link[stats]{symnum}}) rather than as numbers.}

\item{...}{At present no optional arguments are used.}
}
\value{
List object of class \code{"summary.nls"} identical to \code{\link[stats]{summary.nls}}
}
\description{
Returns the model summary for a fitted \code{"gsl_nls"} object.
}
\examples{
## data
set.seed(1)
x <- 1:10
y <- 1 + 0.5 * (1:10) + rnorm(10, sd = 0.1)
## model
obj <- gsl_nls(fn = y ~ a + b * x, data = data.frame(x = x, y = y), start = c(a = 0, b = 1))
summary(obj)
}
\seealso{
\code{\link[stats]{summary.nls}}
}
