\name{gsl-package}
\alias{gsl-package}
\alias{gsl}
\docType{package}
\title{
  Wrappers for the Gnu Scientific Library
}
\description{
  An R wrapper for the special functions and quasi random number
  generators of the Gnu Scientific Library
  (\url{http://www.gnu.org/software/gsl/})
}
\details{
\tabular{ll}{
Package: \tab gsl\cr
Type: \tab Package\cr
Version: \tab 1.8-3\cr
Date: \tab 2007-05-23\cr
License: \tab gsl\cr
}

  The function naming scheme directly copies the GSL manual except that
  leading \code{gsl_sf_} and, if present, the trailing \code{_e} is
  stripped: thus \code{gsl_sf_Airy_Ai_e} goes to \R\ function
  \code{airy_Ai()}; however, some functions retain the prefix to avoid
  conflicts (viz \code{gsl_sf_sin()}, \code{gsl_sf_cos()},
  \code{gsl_sf_gamma()}, \code{gsl_sf_ choose()}, \code{gsl_sf_beta()}).

  \R\ function arguments have the same names as in the GSL reference 
  manual, except for the quasirandom functions documented in the
  \code{Qrng} manpage.

  The package is organized into units corresponding to GSL header files;
  the \code{.c}, \code{.R}, and \code{.Rd} filenames match the GSL header
  filenames, except that the \code{.Rd} files are capitalized.  Functions
  appear in all files in the same order as the GSL reference manual, which
  precludes the use of the tidying method given in section 3.1 of R-exts.
  Error forms of GSL functions (\code{_e} versions) are used if available.

  In general, documentation is limited to: (a), a pointer to the GSL
  reference book, which would in any case dominate any docs here; and (b),
  re-productions of some tables and figures in Abramowitz and Stegun
  (June 1964).
}
\author{
  \itemize{
    \item Robin K. S. Hankin (special functions)
    \item Martin Maechler (quasi random sequences, \code{Qrng.Rd})
    \item Andrew Clausen (function minimization, \code{Multimin.Rd})
  }
Maintainer:  <r.hankin@noc.soton.ac.uk>
}
\references{
  \itemize{
    \item M. Abramowitz and I. A. Stegun 1965. \dQuote{Handbook of
      mathematical functions}.  New York: Dover
    \item M. Galassi et al. 2005. \dQuote{GNU Scientific Library}.
    Reference Manual edition 1.9, for GSL version 1.9; 20 February 2007
    \item R. K. S. Hankin 2006.  \dQuote{Introducing gsl, a wrapper for
      the Gnu Scientific Library}.  Rnews 2006
  }      
}
\keyword{ package }
}
\examples{
airy_Ai(1:5)
}
