% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iirlp2mb.R
\name{iirlp2mb}
\alias{iirlp2mb}
\alias{iirlp2mb.Arma}
\alias{iirlp2mb.Zpg}
\alias{iirlp2mb.Sos}
\alias{iirlp2mb.default}
\title{IIR lowpass filter to IIR multiband}
\usage{
iirlp2mb(b, ...)

\method{iirlp2mb}{Arma}(b, Wo, Wt, type, ...)

\method{iirlp2mb}{Zpg}(b, Wo, Wt, type, ...)

\method{iirlp2mb}{Sos}(b, Wo, Wt, type, ...)

\method{iirlp2mb}{default}(b, a, Wo, Wt, type = c("pass", "stop"), ...)
}
\arguments{
\item{b}{numerator polynomial of prototype low pass filter}

\item{...}{additional arguments (not used)}

\item{Wo}{(normalized angular frequency)/pi to be transformed}

\item{Wt}{vector of (norm. angular frequency)/pi transform targets}

\item{type}{one of "pass" or "stop". Specifies to filter to produce: bandpass
(default) or bandstop.}

\item{a}{denominator polynomial of prototype low pass filter}
}
\value{
List of class \code{\link{Arma}} numerator and denominator
  polynomials of the resulting filter.
}
\description{
Transform an IIR lowpass filter prototype to an IIR multiband filter.
}
\details{
The utility of a prototype filter comes from the property that all other
filters can be derived from it by applying a scaling factor to the components
of the prototype. The filter design need thus only be carried out once in
full, with other filters being obtained by simply applying a scaling factor.
Especially useful is the ability to transform from one bandform to another.
In this case, the transform is more than a simple scale factor. Bandform here
is meant to indicate the category of passband that the filter possesses. The
usual bandforms are lowpass, highpass, bandpass and bandstop, but others are
possible. In particular, it is possible for a filter to have multiple
passbands. In fact, in some treatments, the bandstop filter is considered to
be a type of multiple passband filter having two passbands. Most commonly,
the prototype filter is expressed as a lowpass filter, but other techniques
are possible[1].

Filters with multiple passbands may be obtained by applying the general
transformation described in [2].

Because \code{iirlp2mb} is generic, it can be extended to accept other
inputs.
}
\examples{
## Design a prototype real IIR lowpass elliptic filter with a gain of about
## –3 dB at 0.5pi rad/sample.
el <- ellip(3, 0.1, 30, 0.409)
## Create a real multiband filter with two passbands.
mb1 <- iirlp2mb(el, 0.5, c(.2, .4, .6, .8), 'pass')
## Create a real multiband filter with two stopbands.
mb2 <- iirlp2mb(el, 0.5, c(.2, .4, .6, .8), 'stop')
## Compare the magnitude responses of the filters.
hfl <- freqz(el)
hf1 <- freqz(mb1)
hf2 <- freqz(mb2)
plot(hfl$w, 20 * log10(abs(hfl$h)), type = "l",
    xlab = "Normalized frequency (* pi rad/sample)",
    ylab = "Magnitude (dB)")
lines(hf1$w, 20 * log10(abs(hf1$h)), col="red")
lines(hf2$w, 20 * log10(abs(hf2$h)), col="blue")
legend('bottomleft',
       legend = c('Prototype', 'Two passbands', 'Two Stopbands'),
       col=c("black", "red", "blue"), lty = 1)

}
\references{
[1] \url{https://en.wikipedia.org/wiki/Prototype_filter}\cr
[2] \url{https://en.wikipedia.org/wiki/Prototype_filter#Lowpass_to_multi-band}
}
\author{
Alan J. Greenberger, \email{alanjg@ptd.net}.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
