% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpdpgrow.R
\name{gpFixPost}
\alias{gpFixPost}
\title{Run a Bayesian functional data model under a GP prior whose parameters employ a DP prior}
\usage{
gpFixPost(
  y,
  ipr,
  Omega_t,
  Omega_s,
  gp_mod,
  jitter,
  gp_shape,
  gp_rate,
  noise_shape,
  noise_rate,
  lower,
  upper,
  w,
  n_slice_iter,
  y_index,
  n.iter,
  n.burn,
  n.thin,
  n.tune,
  progress,
  s
)
}
\arguments{
\item{y}{An \emph{N x T} matrix of N observations of \emph{T x 1} functions}

\item{ipr}{An optional input vector of inclusion probabilities for each observation unit in the case
the observed data were acquired through an informative sampling design, so that unbiased
inference about the population requires adjustments to the observed sample.  Defaults to
\code{ipr = rep(1,nrow(y))} indicating an iid sample.}

\item{Omega_t}{A \emph{T x T} matrix of squared Eucidean distances for \code{T} time points}

\item{Omega_s}{A \code{list} object of length \code{L_s}, where each contains the \emph{T x T}
matrix of Euclidean distances associated to each seasonal covariance term.}

\item{gp_mod}{An \emph{L x 1} numeric vector denoting the selected covariance function for each
of \code{L} terms.  \code{gp_mod = 1} is \code{"rq"}.  \code{gp_mod = 2} is \code{"se"}.
\code{gp_mod = 3} is \code{"sn"}.}

\item{jitter}{Numeric value added to diagonals of GP covariance matrix to stabilize inversion.}

\item{gp_shape}{The shape parameter of the Gamma base distribution for the \code{kappa_star}
locations used to sample the DP prior on the \code{P} GP covariance parameters, 
\code{kappa}, for each experimental unit.}

\item{gp_rate}{The rate parameter of the Gamma base distribution for the \code{kappa_star}
locations used to sample the DP prior on the \code{P} GP covariance parameters, 
\code{kappa}, for each experimental unit.}

\item{noise_shape}{The shape parameter of the Gamma base distribution on \code{tau_e}, the
model noise precision parameter. Defaults to \code{noise_shape = 3}.}

\item{noise_rate}{The rate parameter of the Gamma base distribution on \code{tau_e}, the model
noise precision parameter.  Defaults to \code{noise_rate = 1}.}

\item{lower}{Minimum in range of support for GP covariance parameters, \code{kappa}.}

\item{upper}{Maximum in range of support for GP covariance parameters, \code{kappa}.}

\item{w}{Tuning parameter for slice sampling interval width used for GP 
covariance parameters, \code{kappa}.}

\item{n_slice_iter}{Maximum number of steps to widen slice samplind width for
GP covariance parameters, \code{kappa}.}

\item{y_index}{List object where each contains index of time points to use in \code{n}
progressively coarser distribution for sampling \code{kappa} in tempered update steps.}

\item{n.iter}{The number of MCMC sampling iterations}

\item{n.burn}{The number of warm-up iterations to discard}

\item{n.thin}{The interval or step size of post-burn-in samples to return}

\item{n.tune}{The number of tuning iterations to update the slice sampler width, \code{w}.}

\item{progress}{An indicator in \code{{0,1}} denoting whether to display a progress bar during model execution.
\code{progress = 1} displays a progress bar. Defaults to \code{progress = 1}.}

\item{s}{An integer vector inputting cluster membership structure if select \code{fix == TRUE}.}
}
\value{
res A list object containing MCMC runs for all model parameters.
}
\description{
An internal function to \code{\link{gpdpgrow}}
}
\note{
Intended as an internal function for \code{\link{gpdpgrow}}
}
\seealso{
\code{\link{gpdpgrow}}
}
\author{
Terrance Savitsky \email{tds151@gmail.com}
}
