% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{get_annual_gross_yield}
\alias{get_annual_gross_yield}
\title{Lookup table returning expected annual gross yields as function of
elevation and management intensity.}
\usage{
get_annual_gross_yield(elevation, intensity = "high")
}
\arguments{
\item{elevation}{The elevation of the considered site in meters above sea
level.}

\item{intensity}{One of ("high", "middle", "low", "extensive"). Management
intensity for considered site.}
}
\value{
Annual gross yield in t / ha (metric tons per hectare). Note that
1 t/ha = 0.1 kg/m^2.
}
\description{
Based on data from Table 1a in
Lookup Table of expected yield as functions of height and management
intensity after Olivier Huguenin et al. (2017).
}
\examples{
get_annual_gross_yield(1200)
get_annual_gross_yield(1200, intensity = "low")

}
\references{
\insertRef{huguenin2017GrundlagenDuengung}{growR}
}
