% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-geometry-circle.R
\name{grid.pattern_circle}
\alias{grid.pattern_circle}
\title{Circle patterned grobs}
\usage{
grid.pattern_circle(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  colour = gp$col \%||\% "grey20",
  fill = gp$fill \%||\% "grey80",
  angle = 30,
  density = 0.2,
  spacing = 0.05,
  xoffset = 0,
  yoffset = 0,
  alpha = gp$alpha \%||\% NA_real_,
  linetype = gp$lty \%||\% 1,
  size = gp$lwd \%||\% 1,
  grid = "square",
  type = NULL,
  subtype = NULL,
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored}

\item{colour}{Stroke colour}

\item{fill}{Fill colour}

\item{angle}{Rotation angle in degrees}

\item{density}{Approx. fraction of area the pattern fills.}

\item{spacing}{Spacing between repetitions of pattern ('snpc' units between 0 and 1).}

\item{xoffset}{Shift pattern along x axis ('snpc' units between 0 and 1).}

\item{yoffset}{Shift pattern along y axis ('snpc' units between 0 and 1).}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).}

\item{linetype}{Stroke linetype}

\item{size}{Stroke linewidth}

\item{grid}{Adjusts placement and density of certain graphical elements.
\code{"square"} (default) is a square grid.
\code{"hex"} is a hexagonal grid suitable for hexagonal and triangular tiling.
\code{"hex_circle"} is a hexagonal grid suitable for circle packing.}

\item{type}{Adjusts the repeating of certain aesthetics such as color.
Can use any type in \code{names_hex}, \code{names_square}, or \code{names_weave}.
See for \code{\link[=pattern_hex]{pattern_hex()}}, \code{\link[=pattern_square]{pattern_square()}}, and \code{\link[=pattern_weave]{pattern_weave()}} for
more information about supported \code{type} arguments.}

\item{subtype}{See for \code{\link[=pattern_hex]{pattern_hex()}}, \code{\link[=pattern_square]{pattern_square()}}, and \code{\link[=pattern_weave]{pattern_weave()}} for
more information about supported \code{subtype} arguments.}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_circle()} draws a circle pattern onto the graphic device.
}
\examples{
  if (require("grid")) {
    x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    grid.pattern_circle(x_hex, y_hex, fill = c("blue", "yellow"), density = 0.5)
    grid.newpage()
    grid.pattern_circle(x_hex, y_hex, density = 0.8, grid = "hex_circle",
                        gp = gpar(fill = c("blue", "yellow", "red")))
    grid.newpage()
    grid.pattern_circle(x_hex, y_hex, density = 1.2, grid = "hex_circle",
                        gp = gpar(fill = c("blue", "yellow", "red")))

    # using a "twill_zigzag" 'weave' pattern
    grid.newpage()
    grid.pattern_circle(x_hex, y_hex, fill = "blue", density = 0.5, type = "twill_zigzag")
  }
}
\seealso{
See \code{\link[=grid.pattern_regular_polygon]{grid.pattern_regular_polygon()}} for a more general case of this pattern.
}
