% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_partial_effect.R
\name{average_partial_effect}
\alias{average_partial_effect}
\title{Estimate average partial effects using a causal forest}
\usage{
average_partial_effect(
  forest,
  calibrate.weights = TRUE,
  subset = NULL,
  debiasing.weights = NULL,
  num.trees.for.variance = 500
)
}
\arguments{
\item{forest}{The trained forest.}

\item{calibrate.weights}{Whether to force debiasing weights to match expected
moments for 1, W, W.hat, and 1/Var[W|X].}

\item{subset}{Specifies a subset of the training examples over which we
estimate the ATE. WARNING: For valid statistical performance,
the subset should be defined only using features Xi, not using
the treatment Wi or the outcome Yi.}

\item{debiasing.weights}{A vector of length n (or the subset length) of debiasing weights.
If NULL (default) these are estimated by a variance forest.}

\item{num.trees.for.variance}{Number of trees used to estimate Var[Wi | Xi = x]. Default is 500.
(only applies when debiasing.weights = NULL)}
}
\value{
An estimate of the average partial effect, along with standard error.
}
\description{
Gets estimates of the average partial effect, in particular
the (conditional) average treatment effect (target.sample = all):
  1/n sum_{i = 1}^n Cov[Wi, Yi | X = Xi] / Var[Wi | X = Xi].
Note that for a binary unconfounded treatment, the
average partial effect matches the average treatment effect.
}
\details{
If clusters are specified, then each unit gets equal weight by default. For
example, if there are 10 clusters with 1 unit each and per-cluster ATE = 1,
and there are 10 clusters with 19 units each and per-cluster ATE = 0, then
the overall ATE is 0.05 (additional sample.weights allow for custom
weighting). If equalize.cluster.weights = TRUE each cluster gets equal weight
and the overall ATE is 0.5.

Double robust scores are calculated with a component based on a forest
estimate of Var[Wi | Xi = x]. These weights can also be passed manually by
specifying debiasing.weights.
}
\examples{
\donttest{
n <- 2000
p <- 10
X <- matrix(rnorm(n * p), n, p)
W <- rbinom(n, 1, 1 / (1 + exp(-X[, 2]))) + rnorm(n)
Y <- pmax(X[, 1], 0) * W + X[, 2] + pmin(X[, 3], 0) + rnorm(n)
tau.forest <- causal_forest(X, Y, W)
tau.hat <- predict(tau.forest)
average_partial_effect(tau.forest)
average_partial_effect(tau.forest, subset = X[, 1] > 0)
}

}
