% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_tuning.R
\name{tune_causal_forest}
\alias{tune_causal_forest}
\title{Causal forest tuning}
\usage{
tune_causal_forest(X, Y, W, num.fit.trees = 200, num.fit.reps = 50,
  num.optimize.reps = 1000, min.node.size = NULL,
  sample.fraction = 0.5, mtry = NULL, alpha = NULL,
  imbalance.penalty = NULL, stabilize.splits = TRUE,
  num.threads = NULL, honesty = TRUE, honesty.fraction = NULL,
  seed = NULL, clusters = NULL, samples_per_cluster = NULL)
}
\arguments{
\item{X}{The covariates used in the causal regression.}

\item{Y}{The outcome.}

\item{W}{The treatment assignment (may be binary or real).}

\item{num.fit.trees}{The number of trees in each 'mini forest' used to fit the tuning model.}

\item{num.fit.reps}{The number of forests used to fit the tuning model.}

\item{num.optimize.reps}{The number of random parameter values considered when using the model
to select the optimal parameters.}

\item{min.node.size}{A target for the minimum number of observations in each tree leaf. Note that nodes
with size smaller than min.node.size can occur, as in the original randomForest package.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty = TRUE, these subsamples will
further be cut by a factor of honesty.fraction.}

\item{mtry}{Number of variables tried for each split.}

\item{alpha}{A tuning parameter that controls the maximum imbalance of a split.}

\item{imbalance.penalty}{A tuning parameter that controls how harshly imbalanced splits are penalized.}

\item{stabilize.splits}{Whether or not the treatment should be taken into account when
determining the imbalance of a split (experimental).}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{honesty}{Whether to use honest splitting (i.e., sub-sample splitting).}

\item{honesty.fraction}{The fraction of data that will be used for determining splits if honesty = TRUE. Corresponds 
to set J1 in the notation of the paper. When using the defaults (honesty = TRUE and 
honesty.fraction = NULL), half of the data will be used for determining splits}

\item{seed}{The seed of the C++ random number generator.}

\item{clusters}{Vector of integers or factors specifying which cluster each observation corresponds to.}

\item{samples_per_cluster}{If sampling by cluster, the number of observations to be sampled from
each cluster. Must be less than the size of the smallest cluster. If set to NULL
software will set this value to the size of the smallest cluster.#'}
}
\value{
A list consisting of the optimal parameter values ('params') along with their debiased
        error ('error').
}
\description{
Finds the optimal parameters to be used in training a regression forest. This method
currently tunes over min.node.size, mtry, sample.fraction, alpha, and imbalance.penalty.
Please see the method 'causal_forest' for a description of the standard causal forest
parameters. Note that if fixed values can be supplied for any of the parameters mentioned
above, and in that case, that parameter will not be tuned. For example, if this method is
called with min.node.size = 10 and alpha = 0.7, then those parameter values will be treated
as fixed, and only sample.fraction and imbalance.penalty will be tuned.
}
\examples{
\dontrun{
# Find the optimal tuning parameters.
n = 50; p = 10
X = matrix(rnorm(n*p), n, p)
W = rbinom(n, 1, 0.5)
Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)
params = tune_causal_forest(X, Y, W)$params

# Use these parameters to train a regression forest.
tuned.forest = causal_forest(X, Y, W, num.trees = 1000,
    min.node.size = as.numeric(params["min.node.size"]),
    sample.fraction = as.numeric(params["sample.fraction"]),
    mtry = as.numeric(params["mtry"]),
    alpha = as.numeric(params["alpha"]),
    imbalance.penalty = as.numeric(params["imbalance.penalty"])
}

}
