% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_forest.R
\name{regression_forest}
\alias{regression_forest}
\title{Regression forest}
\usage{
regression_forest(X, Y, sample.fraction = 0.5, mtry = NULL,
  num.trees = 2000, num.threads = NULL, min.node.size = NULL,
  honesty = TRUE, honesty.fraction = NULL, ci.group.size = 2,
  alpha = NULL, imbalance.penalty = NULL, compute.oob.predictions = TRUE,
  seed = NULL, clusters = NULL, samples_per_cluster = NULL,
  tune.parameters = FALSE, num.fit.trees = 10, num.fit.reps = 100,
  num.optimize.reps = 1000)
}
\arguments{
\item{X}{The covariates used in the regression.}

\item{Y}{The outcome.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty = TRUE, these subsamples will
further be cut by a factor of honesty.fraction.}

\item{mtry}{Number of variables tried for each split.}

\item{num.trees}{Number of trees grown in the forest. Note: Getting accurate
confidence intervals generally requires more trees than
getting accurate predictions.}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{min.node.size}{A target for the minimum number of observations in each tree leaf. Note that nodes
with size smaller than min.node.size can occur, as in the original randomForest package.}

\item{honesty}{Whether to use honest splitting (i.e., sub-sample splitting).}

\item{honesty.fraction}{The fraction of data that will be used for determining splits if honesty = TRUE. Corresponds 
to set J1 in the notation of the paper. When using the defaults (honesty = TRUE and 
honesty.fraction = NULL), half of the data will be used for determining splits}

\item{ci.group.size}{The forest will grow ci.group.size trees on each subsample.
In order to provide confidence intervals, ci.group.size must
be at least 2.}

\item{alpha}{A tuning parameter that controls the maximum imbalance of a split.}

\item{imbalance.penalty}{A tuning parameter that controls how harshly imbalanced splits are penalized.}

\item{compute.oob.predictions}{Whether OOB predictions on training set should be precomputed.}

\item{seed}{The seed for the C++ random number generator.}

\item{clusters}{Vector of integers or factors specifying which cluster each observation corresponds to.}

\item{samples_per_cluster}{If sampling by cluster, the number of observations to be sampled from
each cluster. Must be less than the size of the smallest cluster. If set to NULL
software will set this value to the size of the smallest cluster.}

\item{tune.parameters}{If true, NULL parameters are tuned by cross-validation; if false
NULL parameters are set to defaults.}

\item{num.fit.trees}{The number of trees in each 'mini forest' used to fit the tuning model.}

\item{num.fit.reps}{The number of forests used to fit the tuning model.}

\item{num.optimize.reps}{The number of random parameter values considered when using the model
to select the optimal parameters.}
}
\value{
A trained regression forest object.
}
\description{
Trains a regression forest that can be used to estimate
the conditional mean function mu(x) = E[Y | X = x]
}
\examples{
\dontrun{
# Train a standard regression forest.
n = 50; p = 10
X = matrix(rnorm(n*p), n, p)
Y = X[,1] * rnorm(n)
r.forest = regression_forest(X, Y)

# Predict using the forest.
X.test = matrix(0, 101, p)
X.test[,1] = seq(-2, 2, length.out = 101)
r.pred = predict(r.forest, X.test)

# Predict on out-of-bag training samples.
r.pred = predict(r.forest)

# Predict with confidence intervals; growing more trees is now recommended.
r.forest = regression_forest(X, Y, num.trees = 100)
r.pred = predict(r.forest, X.test, estimate.variance = TRUE)
}

}
