% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cramer.R
\name{cramer}
\alias{cramer}
\title{Calculate Cramer's V for categorical variables}
\usage{
cramer(x, y, use = c("na.or.complete", "complete.obs", "everything",
  "all.obs"))
}
\arguments{
\item{x}{First categorical variable.}

\item{y}{Second categorical variable.}

\item{use}{What observations to use. See \link[stats]{cor} function for details.
The only option that is not available here is \code{"pairwise.complete.obs"}.}
}
\value{
The following list of values is returned:
\itemize{
\item{value}{The value of Cramer's V;}
\item{statistic}{The value of Chi squared statistic associated with the Cramer's V;}
\item{p.value}{The p-value of Chi squared test associated with the Cramer's V;}
\item{df}{The number of degrees of freedom from the test.}
}
}
\description{
Function calculates Cramer's V for two categorical variables based on the table
function
}
\details{
The function calculates Cramer's V and also returns the associated statistics from
Chi-Squared test with the null hypothesis of independence of the two variables.

See details in the vignette "Marketing analytics with greybox":
\code{vignette("maUsingGreybox","greybox")}
}
\examples{

cramer(mtcars$am, mtcars$gear)

}
\seealso{
\code{\link[base]{table}, \link[greybox]{tableplot}, \link[greybox]{spread},
\link[greybox]{mcor}, \link[greybox]{association}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
