% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec_gretl.R
\name{exec_gretl}
\alias{exec_gretl}
\title{Execute \code{gretl} codes in R}
\usage{
exec_gretl(code,path=basename(tempfile("gretlR")))
}
\arguments{
\item{code}{Object or a character string representing the set of \code{gretl} codes}

\item{path}{Object or a character string representing the directory to execute the \code{gretl} codes (default: \code{gretlR})}
}
\value{
Set of \code{gretl} (open-source software for Econometrics) outputs
}
\description{
Use this function to Execute \code{gretl} codes in R.
}
\examples{
library(gretlR)
\dontrun{
code=r'(nulldata 500
set seed 13
gretl1 = normal()
gretl2 = normal()
setobs 12 1980:01 --time-series
gnuplot gretl1 --time-series --with-lines --output="line.png"
gnuplot gretl2 gretl1 --output="scatter.png"
)'
exec_gretl(code)
}
}
\seealso{
Other important functions: 
\code{\link{eng_gretl}()},
\code{\link{exec_inp}()},
\code{\link{gretlR}},
\code{\link{import_kable}()},
\code{\link{include_graph}()},
\code{\link{include_tex}()},
\code{\link{write_inp}()}
}
\concept{important functions}
\keyword{documentation}
