% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_RootDepSet.R
\name{FlowConnect}
\alias{FlowConnect}
\title{An empty object of class \code{FlowConnect}}
\usage{
FlowConnect()
}
\value{
An object with two empty slots \code{$value} for the collection of subsets of nodes
and \code{$root} for the roots.
}
\description{
It is a subclass of \code{RootDepSet}.
It creates an object with two empty slots \code{$value} for the collection of subsets of nodes
and \code{$root} for the roots
associated to each of the subsets in \code{$value}.
Every node with observable variable should be taken as a root.
A subset of nodes is created for every root.
For every root the subset of nodes is created on the principle of flow connection -
a term from river networks applications.
The slots are supposed to be assigned to some values. The simplest ways is
using method \code{setRootDepSet}. For other examples see Vignette "Subsets and Coordinates".
}
\examples{
seg<- make_tree(7,3, mode = "undirected")
name_stat<- letters[1:7]
seg<- set.vertex.attribute(seg, "name", V(seg), name_stat)

seg_dir<- make_tree(7,3, mode = "in")
seg_dir<- set.vertex.attribute(seg_dir, "name", V(seg_dir), name_stat)
fcg<- FlowConnectionGraph(seg_dir)

rdsobj<- FlowConnect()
subset(rdsobj, from=fcg, g=seg)
}
