% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_flowConnectionInput.R
\name{FlowConnectionGraph}
\alias{FlowConnectionGraph}
\title{Object of class \code{FlowConnectionGraph}}
\usage{
FlowConnectionGraph(g)
}
\arguments{
\item{g}{a directed graph acoording to the water flow. An object of class "igraph". It should have named vertices.}
}
\value{
An object of class \code{FlowConnectionGraph} with one slot containing the directed graph.
}
\description{
It creates an object from class \code{FlowConnectionGraph}. The function verifies whether the graph is
directed and the vertices are named. The object can be used further to create subsets based on the criterion of
flow connectedness. See Vignette "Subsets and Coordinates".
}
\examples{
seg_dir<- graph(c("2","paris", "meaux", "2", "melun", "2","5", "melun","nemours", "5", "sens", "5"),
 directed = TRUE)
fcg<- FlowConnectionGraph(seg_dir)
rds<- FlowConnect()

# call method subset to create subsets
subset(rds, fcg, seg_dir)
}
