% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_coordinates.R
\name{Adjacent}
\alias{Adjacent}
\title{Creates an empty object of class \code{Adjacent}}
\usage{
Adjacent()
}
\value{
An empty object of class \code{Adjacent} which is to be used with method \code{evalPoints} to create matrix of
coordnates.
}
\description{
It is used for creating the coordinates where the stable tail dependence function (stdf) is evaluated.
For instance in the extremal coefficient estimator. For more information about it see
Vignettes "Estimation - Note 3" and "Code - Note 3" and "Subsets and Coordinates". It is designed for use with
method \code{evalPoints}. See the examples therein.
}
\examples{
adj<- Adjacent()
adj
seg<- make_tree(8,2, mode = "undirected")
seg<- set.vertex.attribute(seg, "name", V(seg), letters[1:8])
data<- matrix(rnorm(10*8), 10,8)
colnames(data)<- letters[1:8]
tobj<- Tree(seg, data)

x<- rep(1,8)
names(x)<- get.vertex.attribute(tobj$graph, "name", V(tobj$graph))
ep<- evalPoints(adj, tobj, x)
head(ep)
}
