% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_gfdata.R
\name{report_gfdata}
\alias{report_gfdata}
\title{Download and Report 'GreenFeed' Data}
\arguments{
\item{input_type}{a character string representing type of data (options: "prelim" or "daily, and "final")}

\item{exp}{a character string representing study name or other study identifier. It is used as file name to save the data}

\item{unit}{numeric or character vector, or a list representing one or more 'GreenFeed' unit numbers}

\item{start_date}{a character string representing the start date of the study (format: "mm/dd/yyyy")}

\item{end_date}{a character string representing the end date of the study (format: "mm/dd/yyyy")}

\item{save_dir}{a character string representing the directory to save the output file}

\item{plot_opt}{a character string representing the gas(es) to plot (options: "All", "CH4", "CO2", "O2", "H2")}

\item{rfid_file}{a character string representing the file with individual IDs. The order should be Visual ID (col1) and RFID (col2)}

\item{user}{a character string representing the user name to logging into 'GreenFeed' system. If input_type is "final", this parameter is ignored}

\item{pass}{a character string representing password to logging into 'GreenFeed' system. If input_type is "final", this parameter is ignored}

\item{file_path}{A list of file paths containing the final report(s) from the 'GreenFeed' system. If input_type is "prelim", this parameter is ignored}
}
\value{
A CSV file with preliminary 'GreenFeed' data and a PDF report with a description of the preliminary or finalized data
}
\description{
Generates a PDF report of preliminary and finalized 'GreenFeed' data.
    The report includes: number of animals using 'GreenFeed' and plots with distribution of records and gas production.
    If the preliminary option is used, the data is retrieved from the 'C-Lock Inc.' server through an 'API',
    otherwise the data processed by 'C-Lock Inc.' must be provided to generate the report.
}
\examples{
\dontshow{if (has_credentials()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Please replace "your_username" and "your_password" with your actual 'GreenFeed' credentials.
# The data range must be fewer than 180 days
# Example without rfid_file (by default NA)

report_gfdata(
  user = "your_username",
  pass = "your_password",
  input_type = "prelim",
  exp = "StudyName",
  unit = 1,
  start_date = "2023-01-01",
  end_date = Sys.Date(),
  save_dir = tempdir(),
  plot_opt = "All"
)
\dontshow{\}) # examplesIf}
}
