% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessibility_greenspace.R
\name{accessibility_greenspace}
\alias{accessibility_greenspace}
\title{Generate Accessibility Map for Green Spaces}
\usage{
accessibility_greenspace(
  green_area_data,
  location_lat,
  location_lon,
  max_walk_time = 15,
  green_color = "green",
  location_color = "blue",
  isochrone_color = "viridis"
)
}
\arguments{
\item{green_area_data}{A list containing green area data, usually obtained from the \code{get_osm_data} function.}

\item{location_lat}{Numeric latitude of the specified location.}

\item{location_lon}{Numeric longitude of the specified location.}

\item{max_walk_time}{Maximum walking time in minutes. Default is 15.}

\item{green_color}{Color for the green areas on the map. Default is "green".}

\item{location_color}{Color for the specified location on the map. Default is "blue".}

\item{isochrone_color}{Color palette for the isochrone lines. Default is "viridis".}
}
\value{
A leaflet map object.
}
\description{
This function generates a leaflet map that shows green spaces accessible within
a specified walking time from a given location. The location is specified by its
latitude and longitude coordinates.
}
\examples{
\dontrun{
  green_area_data <- data$green_areas
  accessibility_greenspace(data, 47.56, 7.59)
}
}
