% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BS_Implied_Volatility.R
\name{BS_Implied_Volatility}
\alias{BS_Implied_Volatility}
\title{Computes the implied volatility for European options via Halley's method.}
\usage{
BS_Implied_Volatility(
  option_price,
  initial_price = 100,
  exercise_price = 100,
  r = 0,
  time_to_maturity = 1,
  dividend_yield = 0,
  payoff = "call",
  start_volatility = 0.3,
  precision = 1e-09
)
}
\arguments{
\item{option_price}{\itemize{
\item current price of the option
}}

\item{initial_price}{\itemize{
\item initial price of the underlying asset.
}}

\item{exercise_price}{\itemize{
\item strike price of the option.
}}

\item{r}{\itemize{
\item risk-free interest rate.
}}

\item{time_to_maturity}{\itemize{
\item time to maturity.
}}

\item{dividend_yield}{\itemize{
\item dividend yield.
}}

\item{payoff}{\itemize{
\item the payoff function, a string in ("call", "put").
}}

\item{start_volatility}{\itemize{
\item the volatility value to start the approximation
}}

\item{precision}{\itemize{
\item precision of the result
}}
}
\value{
Named vector containing the values of the Greeks specified in the
parameter \code{greek}.
}
\description{
Computes the implied volatility for European options via Halley's method.
}
\examples{
BS_Implied_Volatility(option_price = 27, initial_price = 100,
exercise_price = 100, r = 0.03, time_to_maturity = 5, dividend_yield = 0.015,
payoff = "call")
}
