% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sapto.R
\name{sapto}
\alias{sapto}
\title{Seniors and Pensioner Tax Offset}
\usage{
sapto(
  rebate_income,
  fy.year,
  fill = 0,
  sapto.eligible = TRUE,
  Spouse_income = 0,
  family_status = "single",
  on_sapto_cd = "A",
  .check = TRUE
)
}
\arguments{
\item{rebate_income}{The rebate income of the individual.}

\item{fy.year}{The financial year in which sapto is to be calculated.}

\item{fill}{If SAPTO was not applicable, what value should be used?}

\item{sapto.eligible}{Is the individual eligible for sapto?}

\item{Spouse_income}{Spouse income whose unutilized SAPTO may be added to the current taxpayer. Must match \code{family_status}; i.e. can only be nonzero when \code{family_status != "single"}.}

\item{family_status}{Family status of the individual.}

\item{on_sapto_cd}{SAPTO claim code type (for non-veterans). A 
letter A-E. A = single, B = lived apart due to illness and spouse was eligible,
 C = lived apart but spouse ineligible, D = lived together, both eligible for sapto, 
 E = lived together, spouse ineligible. Only \code{"A"} and \code{"D"} are supported.}

\item{.check}{Run checks for consistency of values. For example, ensuring no 
single individuals have positive \code{Spouse_income}.}
}
\description{
Seniors and Pensioner Tax Offset
}
