% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rent_assistance.R
\name{rent_assistance}
\alias{rent_assistance}
\title{Rent assistance}
\usage{
rent_assistance(
  fortnightly_rent = Inf,
  per = "fortnight",
  fy.year = NULL,
  Date = NULL,
  n_dependants = 0L,
  has_partner = FALSE,
  .prop_rent_paid_by_RA = 0.75,
  max_rate = NULL,
  min_rent = NULL,
  sharers_provision_applies = FALSE,
  is_homeowner = FALSE,
  lives_in_sharehouse = FALSE
)
}
\arguments{
\item{fortnightly_rent}{The fortnightly rent paid by each individual. By 
default, infinity, so the maximum rent assistance is returned by default, 
since rent assistance is capped at a maximum rate. Note the criteria for board
 and lodging which can be found at \url{https://guides.dss.gov.au/guide-social-security-law/3/8/1/70}}

\item{per}{Specifies the timeframe in which payments will be made. Can either
take value "fortnight" or "annual".}

\item{fy.year}{(character) The financial year over which rent assistance is 
to be calculated. When left as \code{NULL}, defaults to the user's financial 
year, unless \code{max_rate} and \code{min_rent} are both set. If 
\code{fy.year} is set, the annual payment is provided.}

\item{Date}{(Date vector or coercible to such) An alternative to \code{fy.year}.
If both \code{fy.year} and \code{Date} are provided, \code{fy.year} is ignored, with a warning. 
If \code{Date} is used, the fortnightly rent assistance is provided.}

\item{n_dependants}{(integer) Number of dependent children. By default, \code{0L}, so no children.}

\item{has_partner}{(logical) Is each individual married? By default, \code{FALSE}.}

\item{.prop_rent_paid_by_RA}{The proportion of the rent above the minimum threshold paid by rent assistance. 
Since it so happens that this value is constant over the period, it is set here rather than being added to 
the internal table.}

\item{max_rate}{If not \code{NULL}, a numeric vector indicating for each individual the maximum rent assistance payable.}

\item{min_rent}{If not \code{NULL}, a numeric vector indicating for each individual the minimum fortnightly rent above which rent assistance is payable. \code{max_rate} and \code{min_rent} must not be used when \code{fy.year} is set.}

\item{sharers_provision_applies}{(logical, default: FALSE) Does the sharers provision apply to the parent payment? The list of functions can be found in table 2 column 4 \url{https://guides.dss.gov.au/guide-social-security-law/3/8/1/10}}

\item{is_homeowner}{(logical, default: \code{FALSE}) Does the individual own 
their own home?}

\item{lives_in_sharehouse}{(logical, default: \code{FALSE}) Does the individual
live in a sharehouse?}
}
\value{
If \code{fy.year} is used, the annual rent assistance payable for each individual; 
if \code{Date} is used, the \emph{fortnightly} rent assistance payable.
If the arguments cannot be recycled safely, the function errors.
}
\description{
The rent assistance to each individual payable by financial year.
}
\examples{
# current annual rent assistance
rent_assistance()  

# current fortnightly payment
rent_assistance(Date = Sys.Date())  

# zero since no rent
rent_assistance(0, Date = "2016-01-02") 

# Rent assistance is payable at 75c for every dollar over min rent
rent_assistance(101, max_rate = 500, min_rent = 100)
rent_assistance(500, max_rate = 500, min_rent = 100)

}
