% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_to.R
\name{project_to}
\alias{project_to}
\title{Simple projections of the annual 2\% samples of Australian Taxation Office tax returns.}
\usage{
project_to(sample_file, to_fy, fy.year.of.sample.file = NULL, ...)
}
\arguments{
\item{sample_file}{A \code{data.table} matching a 2\% sample file from the ATO.
See package \code{taxstats} for an example.}

\item{to_fy}{A string like "1066-67" representing the financial year for which forecasts of the sample file are desired.}

\item{fy.year.of.sample.file}{The financial year of \code{sample_file}. See \code{\link{project}} for the default.}

\item{...}{Other arguments passed to \code{\link{project}}.}
}
\value{
A sample file with the same number of rows as \code{sample_file} but 
with inflated values as a forecast for the sample file in \code{to_fy}. 
If \code{WEIGHT} is not already a column of \code{sample_file}, it will be added and its sum
will be the predicted number of taxpayers in \code{to_fy}.
}
\description{
Simple projections of the annual 2\% samples of Australian Taxation Office tax returns.
}
