% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdp.R
\name{gdp}
\alias{gdp}
\alias{gdp_qtr}
\alias{gdp_fy}
\title{Gross Domestic Product, Australia}
\source{
Australian Bureau of Statistics, Catalogue 5206.0. Series A2304350J.
}
\usage{
gdp_qtr(date, roll = "nearest")

gdp_fy(fy_year)
}
\arguments{
\item{date}{A Date vector or character coercible thereto.}

\item{roll}{Passed to \code{data.table} when joining.}

\item{fy_year}{Character vector of financial years.}
}
\value{
For \code{gdp_qtr}, the quarterly GDP for the quarter date nearest (or otherwise using \code{roll}). 
For \code{gdp_fy} the sum over the quarters in the financial year provided. 
If \code{fy_year} would provide incomplete data (i.e. only sum three or fewer quarters), a warning is issued.
Dates or fy_year outside the available data is neither a warning nor an error, but \code{NA}.
}
\description{
Gross domestic product, at contemporaneous prices (called 'current prices' by the ABS).
}
