% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-methods.R
\name{draw.penalty_df}
\alias{draw.penalty_df}
\title{Display penalty matrices of smooths using \code{ggplot}}
\usage{
\method{draw}{penalty_df}(
  object,
  normalize = FALSE,
  as_matrix = TRUE,
  continuous_fill = NULL,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ncol = NULL,
  nrow = NULL,
  guides = "keep",
  ...
)
}
\arguments{
\item{object}{a fitted GAM, the result of a call to \code{\link[mgcv:gam]{mgcv::gam()}}.}

\item{normalize}{logical; normalize the penalty to the range -1, 1?}

\item{as_matrix}{logical; how should the plotted penalty matrix be oriented?
If \code{TRUE} row 1, column 1 of the penalty matrix is draw in the upper left,
whereas, if \code{FALSE} it is drawn in the lower left of the plot.}

\item{continuous_fill}{a suitable fill scale to be used when plotting
continuous variables.}

\item{xlab}{character or expression; the label for the x axis. If not
supplied, no axis label will be drawn. May be a vector, one per penalty.}

\item{ylab}{character or expression; the label for the y axis.  If not
supplied, no axis label will be drawn. May be a vector, one per penalty.}

\item{title}{character or expression; the title for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}. May be a vector, one per penalty.}

\item{subtitle}{character or expression; the subtitle for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}. May be a vector, one per penalty.}

\item{caption}{character or expression; the plot caption. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}. May be a vector, one per penalty.}

\item{ncol, nrow}{numeric; the numbers of rows and columns over which to
spread the plots.}

\item{guides}{character; one of \code{"keep"} (the default), \code{"collect"}, or
\code{"auto"}. Passed to \code{\link[patchwork:plot_layout]{patchwork::plot_layout()}}}

\item{...}{additional arguments passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.}
}
\description{
Displays the penalty matrices of smooths as a heatmap using \code{ggplot}
}
\examples{
load_mgcv()
dat <- data_sim("eg4", n = 400, seed = 42)
m <- gam(y ~ s(x0) + s(x1, bs = "cr") + s(x2, bs = "bs", by = fac),
  data = dat, method = "REML"
)

## produce a multi-panel plot of all penalties
draw(penalty(m))

# for a specific smooth
draw(penalty(m, select = "s(x2):fac1"))
}
