% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth-data.R
\name{smooth_data}
\alias{smooth_data}
\title{Generate regular data over the covariates of a smooth}
\usage{
smooth_data(
  model,
  id,
  n = 100,
  n_3d = NULL,
  n_4d = NULL,
  offset = NULL,
  include_all = FALSE
)
}
\arguments{
\item{model}{a fitted model}

\item{id}{the number ID of the smooth within \code{model} to process.}

\item{n}{numeric; the number of new observations to generate.}

\item{n_3d}{numeric; the number of new observations to generate for the third
dimension of a 3D smooth.}

\item{n_4d}{numeric; the number of new observations to generate for the
dimensions higher than 2 (!) of a \emph{k}D smooth (\emph{k} >= 4). For example, if
the smooth is a 4D smooth, each of dimensions 3 and 4 will get \code{n_4d}
new observations.}

\item{offset}{numeric; value of the model offset to use.}

\item{include_all}{logical; include all covariates involved in the smooth?
if \code{FALSE}, only the covariates involved in the smooth will be included in
the returned data frame. If \code{TRUE}, a representative value will be included
for all other covariates in the model that aren't actually used in the
model. This can be useful if you want to pass the returned data frame on to
\code{\link[mgcv:smoothCon]{mgcv::PredictMat()}}.}
}
\description{
Generate regular data over the covariates of a smooth
}
